package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponAPI.WeaponType;
import com.fs.starfarer.api.impl.combat.AcausalDisruptorStats;

public class SWP_AcausalDisruptorStats extends AcausalDisruptorStats {

    @Override
    public void apply(MutableShipStatsAPI stats, String id, State state, float effectLevel) {
        ShipAPI ship;
        if (stats.getEntity() instanceof ShipAPI) {
            ship = (ShipAPI) stats.getEntity();
        } else {
            return;
        }

        stats.getEnergyWeaponDamageMult().modifyMult(id, ENERGY_DAM_PENALTY_MULT);

        float jitterLevel = effectLevel;
        if (state == State.OUT) {
            jitterLevel *= jitterLevel;
        }
        float maxRangeBonus = 50f;
        float jitterRangeBonus = jitterLevel * maxRangeBonus;

        ship.setJitterUnder(this, JITTER_UNDER_COLOR, jitterLevel, 21, 0f, 3f + jitterRangeBonus);
        ship.setJitter(this, JITTER_COLOR, jitterLevel, 4, 0f, 0 + jitterRangeBonus);

        String targetKey = ship.getId() + "_acausal_target";
        Object foundTarget = Global.getCombatEngine().getCustomData().get(targetKey);
        if (state == State.IN) {
            for (WeaponAPI weapon : ship.getAllWeapons()) {
                if (weapon.getType() == WeaponType.MISSILE && weapon.getCooldownRemaining() < 1f) {
                    weapon.setRemainingCooldownTo(1f);
                }
            }
            if (foundTarget == null) {
                ShipAPI target = findTarget(ship);
                if (target != null) {
                    Global.getCombatEngine().getCustomData().put(targetKey, target);
                    float baseCapacity = ship.getMutableStats().getFluxCapacity().getBaseValue();
                    if (target.isDestroyer()) {
                        ship.getSystem().setFluxPerSecond(baseCapacity * 0.15f);
                    }
                    if (target.isCruiser()) {
                        ship.getSystem().setFluxPerSecond(baseCapacity * 0.3f);
                    }
                    if (target.isCapital()) {
                        ship.getSystem().setFluxPerSecond(baseCapacity * 0.45f);
                    }
                }
            }
        } else if (effectLevel >= 1) {
            ship.getSystem().setFluxPerSecond(0f);
            if (foundTarget instanceof ShipAPI) {
                ShipAPI target = (ShipAPI) foundTarget;
                if (target.getFluxTracker().isOverloadedOrVenting()) {
                    target = ship;
                }
                applyEffectToTarget(ship, target);
            }
        } else if (state == State.OUT && foundTarget != null) {
            Global.getCombatEngine().getCustomData().remove(targetKey);
        }
    }

    @Override
    public StatusData getStatusData(int index, State state, float effectLevel) {
        float percent = (1f - ENERGY_DAM_PENALTY_MULT) * 100;
        if (index == 0) {
            return new StatusData((int) percent + "% less energy damage", true);
        }
        if (index == 1) {
            return new StatusData("missile systems disrupted", true);
        }
        return null;
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship;
        if (stats.getEntity() instanceof ShipAPI) {
            ship = (ShipAPI) stats.getEntity();
            ship.getSystem().setFluxPerSecond(0f);
        }
        stats.getEnergyWeaponDamageMult().unmodify(id);
    }
}
